/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.model;

import frc.emul.debug.model.DebugSourceFile;
import frc.emul.util.Utils;

public class DebugLine {
    private DebugSourceFile dbgSrcFile;
    private int lineAddr;
    private int lineRow;

    DebugLine(int n, int n2, DebugSourceFile debugSourceFile) {
        this.lineAddr = n;
        this.lineRow = n2;
        this.dbgSrcFile = debugSourceFile;
    }

    public String toString() {
        return "$" + Utils.HEX4(this.lineAddr) + " (line " + (this.lineRow + 1) + " in " + this.dbgSrcFile.getFile().getName() + ")\t-> [" + this.getContent() + "]";
    }

    public int getAddress() {
        return this.lineAddr;
    }

    public int getRow() {
        return this.lineRow;
    }

    public String getContent() {
        return this.dbgSrcFile.getLineContent(this.lineRow);
    }

    public DebugSourceFile getSource() {
        return this.dbgSrcFile;
    }
}

